@echo off
@rem Script to build LPC55Sxx Master Boot Image using nxpimage tool

@rem Environment variables - absolute paths simplifying re-use of the script on another machine
@rem  - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
SETLOCAL ENABLEDELAYEDEXPANSION
if "%SPT_WORKSPACE%"=="" (
  SET "SPT_WORKSPACE=%~dp0"
  SET "SPT_WORKSPACE=!SPT_WORKSPACE:~0,-1!"
)
ENDLOCAL & SET "SPT_WORKSPACE=%SPT_WORKSPACE%"
if not exist "%SPT_WORKSPACE%\" (
  @echo FAILURE: Directory not found "%SPT_WORKSPACE%\"
  exit 2
)
@rem  - Absolute path to SPT installation directory
if "%SPT_INSTALL_BIN%"=="" (
  SET "SPT_INSTALL_BIN=C:\nxp\MCUX_Provi_v8\bin"
)
if not exist "%SPT_INSTALL_BIN%\" (
  @echo FAILURE: Directory not found "%SPT_INSTALL_BIN%\"
  exit 2
)

@rem Used command line utilities
SET "nxpimage=%SPT_INSTALL_BIN%\tools_scripts\nxpimage_spsdk_win_wrapper.bat"
SET "pfr=%SPT_INSTALL_BIN%\tools\spsdk\pfr.exe"

if not exist "%SPT_WORKSPACE%\bootable_images\." (
    mkdir "%SPT_WORKSPACE%\bootable_images"
    if errorlevel 1 exit 2
)

@echo ### Create bootable image ###
call "%nxpimage%" mbi export -c "%SPT_WORKSPACE%\configs\mbi_config.json"
if errorlevel 2 exit 2

@echo ### Create CFPA page - binary ###
pushd "%SPT_WORKSPACE%"
@echo %pfr% generate-binary -c \"%SPT_WORKSPACE%\configs\cfpa.json\" -o \"%SPT_WORKSPACE%\configs\cfpa.bin\"
"%pfr%" generate-binary -c "%SPT_WORKSPACE%\configs\cfpa.json" ^
		-o "%SPT_WORKSPACE%\configs\cfpa.bin"
if errorlevel 1 (
    popd
    exit 2
)
popd

@echo ### Create CMPA page - binary ###
pushd "%SPT_WORKSPACE%"
@echo %pfr% generate-binary -c %SPT_WORKSPACE%\configs\cmpa.json -o %SPT_WORKSPACE%\configs\cmpa.bin
"%pfr%" generate-binary -c "%SPT_WORKSPACE%\configs\cmpa.json" ^
        -o "%SPT_WORKSPACE%\configs\cmpa.bin"
if errorlevel 1 (
    popd
    exit 2
)
popd